/*
 * Decompiled with CFR 0.152.
 */
package org.pokesplash.gts.command.subcommand;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.google.gson.JsonElement;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.pokesplash.gts.Gts;
import org.pokesplash.gts.Listing.ItemListing;
import org.pokesplash.gts.Listing.Listing;
import org.pokesplash.gts.Listing.PokemonListing;
import org.pokesplash.gts.api.GtsAPI;
import org.pokesplash.gts.command.superclass.Subcommand;
import org.pokesplash.gts.config.ItemPrices;
import org.pokesplash.gts.config.PokemonAspects;
import org.pokesplash.gts.config.PokemonPrices;
import org.pokesplash.gts.util.CodecUtils;
import org.pokesplash.gts.util.Utils;

public class List
extends Subcommand {
    public List() {
        super("\u00a79Usage:\n\u00a73- gts sell <pokemon/item>");
    }

    public LiteralCommandNode<class_2168> build() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"sell").requires(ctx -> {
            if (ctx.method_43737()) {
                return Gts.permissions.hasPermission(ctx.method_44023(), "sell");
            }
            return true;
        })).executes(this::showUsage)).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"pokemon").requires(ctx -> {
            if (ctx.method_43737()) {
                return Gts.config.isEnablePokemonSales();
            }
            return false;
        })).executes(this::showPokemonUsage)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"slot", (ArgumentType)IntegerArgumentType.integer()).suggests((ctx, builder) -> {
            for (int x = 0; x < 6; ++x) {
                builder.suggest(x + 1);
            }
            return builder.buildFuture();
        }).executes(this::showPokemonUsage)).then(class_2170.method_9244((String)"price", (ArgumentType)FloatArgumentType.floatArg()).suggests((ctx, builder) -> {
            for (double price : Gts.config.getAllPokemonPrices()) {
                if (!(price > 0.0)) continue;
                builder.suggest((int)price);
            }
            return builder.buildFuture();
        }).executes(this::run))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"item").requires(ctx -> {
            if (ctx.method_43737()) {
                return Gts.config.isEnableItemSales();
            }
            return false;
        })).executes(this::showItemUsage)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"price", (ArgumentType)FloatArgumentType.floatArg()).suggests((ctx, builder) -> {
            for (int i = 1; i <= 11; ++i) {
                builder.suggest(i * 100);
            }
            return builder.buildFuture();
        }).executes(this::showItemUsage)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer()).suggests((ctx, builder) -> {
            for (int i = 0; i <= 64; ++i) {
                builder.suggest(i + 1);
            }
            return builder.buildFuture();
        }).executes(this::run)).then(class_2170.method_9244((String)"stackSize", (ArgumentType)IntegerArgumentType.integer()).suggests((ctx, builder) -> {
            for (int i = 1; i <= 32; ++i) {
                builder.suggest(i);
            }
            return builder.buildFuture();
        }).executes(this::run)))))).build();
    }

    @Override
    public int run(CommandContext<class_2168> context) {
        if (!((class_2168)context.getSource()).method_43737()) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"This command must be ran by a player."));
            return 1;
        }
        if (!Gts.timeouts.hasTimeoutExpired(((class_2168)context.getSource()).method_44023().method_5667())) {
            long endTime = Gts.timeouts.getTimeout(((class_2168)context.getSource()).method_44023().method_5667());
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("\u00a7cYou have been timed out for " + Utils.parseLongDate(endTime - new Date().getTime()))));
            return 1;
        }
        try {
            int totalExpiredListings;
            PokemonBattle battle = Cobblemon.INSTANCE.getBattleRegistry().getBattleByParticipatingPlayer(((class_2168)context.getSource()).method_44023());
            if (battle != null) {
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"\u00a7cYou can not list to GTS while in a battle."));
                return 1;
            }
            int totalListings = Gts.listings.getListingsByPlayer(((class_2168)context.getSource()).method_44023().method_5667()).size();
            java.util.List<Listing> expiredListings = Gts.listings.getExpiredListingsOfPlayer(((class_2168)context.getSource()).method_44023().method_5667());
            int n = totalExpiredListings = expiredListings == null ? 0 : expiredListings.size();
            if (totalListings + totalExpiredListings >= Gts.config.getMaxListingsPerPlayer()) {
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)Utils.formatPlaceholders(Gts.language.getMaximumListings(), 0.0, null, ((class_2168)context.getSource()).method_44023().method_5476().getString(), null)));
                return 1;
            }
            if (context.getInput().contains("pokemon")) {
                return this.runPokemon(context);
            }
            return this.runItem(context);
        }
        catch (Exception e) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"\u00a7cSomething went wrong."));
            e.printStackTrace();
            return 1;
        }
    }

    public int runPokemon(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        int slot = IntegerArgumentType.getInteger(context, (String)"slot") - 1;
        double price = FloatArgumentType.getFloat(context, (String)"price");
        PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(player);
        Pokemon pokemon = party.get(slot);
        if (pokemon == null) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)Utils.formatPlaceholders(Gts.language.getNoPokemonInSlot(), 0.0, null, player.method_5476().getString(), null)));
            return 1;
        }
        if (!pokemon.getTradeable()) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"\u00a7cThis Pokemon is not tradeable."));
            return 1;
        }
        if (party.occupied() < 2) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)Utils.formatPlaceholders(Gts.language.getOnlyOnePokemonInParty(), 0.0, null, player.method_5476().getString(), null)));
            return 1;
        }
        AtomicInteger totalMaxIvs = new AtomicInteger();
        pokemon.getIvs().forEach(stat -> {
            if ((Integer)stat.getValue() == 31) {
                totalMaxIvs.addAndGet(1);
            }
        });
        double minPrice = 0.0;
        switch (totalMaxIvs.get()) {
            case 1: {
                minPrice += Gts.config.getMinPrice1IV();
                break;
            }
            case 2: {
                minPrice += Gts.config.getMinPrice2IV();
                break;
            }
            case 3: {
                minPrice += Gts.config.getMinPrice3IV();
                break;
            }
            case 4: {
                minPrice += Gts.config.getMinPrice4IV();
                break;
            }
            case 5: {
                minPrice += Gts.config.getMinPrice5IV();
                break;
            }
            case 6: {
                minPrice += Gts.config.getMinPrice6IV();
            }
        }
        if (Utils.isHA(pokemon)) {
            minPrice += Gts.config.getMinPriceHA();
        }
        if (pokemon.isLegendary()) {
            minPrice += Gts.config.getMinPriceLegendary();
        }
        if (pokemon.isUltraBeast()) {
            minPrice += Gts.config.getMinPriceUltrabeast();
        }
        java.util.List<PokemonPrices> minPrices = Gts.config.getCustomPokemonPrices();
        for (PokemonPrices pokemonPrices : minPrices) {
            if (!pokemonPrices.getPokemon().equals(pokemon)) continue;
            minPrice += pokemonPrices.getPrice();
            break;
        }
        if (price < minPrice) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)Utils.formatPlaceholders(Gts.language.getMinimumListingPrice(), minPrice, pokemon.getDisplayName().getString(), player.method_5476().getString(), null)));
            return 1;
        }
        if (price > Gts.config.getMaximumPrice()) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)Utils.formatPlaceholders(Gts.language.getMaximumListingPrice(), minPrice, pokemon.getDisplayName().getString(), player.method_5476().getString(), null)));
            return 1;
        }
        java.util.List<PokemonAspects> bannedPokemon = Gts.config.getBannedPokemon();
        for (PokemonAspects bannedMon : bannedPokemon) {
            if (!bannedMon.equals(pokemon)) continue;
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)Utils.formatPlaceholders(Gts.language.getBannedPokemon(), 0.0, pokemon.getSpecies().getName(), player.method_5476().getString(), null)));
            return 1;
        }
        PokemonListing pokemonListing = new PokemonListing(player.method_5667(), player.method_5477().getString(), price, pokemon);
        boolean success = GtsAPI.addListing(pokemonListing, player, slot);
        if (success) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)Utils.formatPlaceholders(Gts.language.getListingSuccess(), minPrice, pokemon.getDisplayName().getString(), player.method_5476().getString(), null)));
        } else {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)Utils.formatPlaceholders(Gts.language.getListingFail(), minPrice, pokemon.getDisplayName().getString(), player.method_5476().getString(), null)));
        }
        return 1;
    }

    public int runItem(CommandContext<class_2168> context) {
        int stackSize;
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        double price = FloatArgumentType.getFloat(context, (String)"price");
        try {
            stackSize = IntegerArgumentType.getInteger(context, (String)"stackSize");
        }
        catch (Exception e) {
            stackSize = amount;
        }
        java.util.List<ItemPrices> minPrices = Gts.config.getCustomItemPrices();
        java.util.List<JsonElement> bannedItems = Gts.config.getBannedItems();
        try {
            class_1799 item = ((class_2168)context.getSource()).method_44023().method_6047();
            if (item == null) {
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)Utils.formatPlaceholders(Gts.language.getNoItemInHand(), 0.0, null, player.method_5476().getString(), null)));
                return 1;
            }
            if (amount <= 0) {
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)Utils.formatPlaceholders(Gts.language.getZeroItemAmount(), 0.0, item.method_7954().getString(), player.method_5476().getString(), null)));
                return 1;
            }
            for (JsonElement bannedItem : bannedItems) {
                class_1799 banned = CodecUtils.decodeItem(bannedItem);
                if (!banned.method_7909().equals(item.method_7909()) || !class_1799.method_31577((class_1799)banned, (class_1799)item)) continue;
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)Utils.formatPlaceholders(Gts.language.getBannedItem(), 0.0, item.method_7954().getString(), player.method_5476().getString(), null)));
                return 1;
            }
            double minPrice = 0.0;
            for (ItemPrices minItem : minPrices) {
                class_1799 min = CodecUtils.decodeItem(minItem.getItem());
                if (!min.method_7909().equals(item.method_7909()) || !class_1799.method_31577((class_1799)min, (class_1799)item)) continue;
                minPrice += minItem.getMinPrice();
                break;
            }
            if (price < minPrice) {
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)Utils.formatPlaceholders(Gts.language.getMinimumListingPrice(), minPrice, item.method_7954().getString(), player.method_5476().getString(), null)));
                return 1;
            }
            if (price > Gts.config.getMaximumPrice()) {
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)Utils.formatPlaceholders(Gts.language.getMaximumListingPrice(), minPrice, item.method_7954().getString(), player.method_5476().getString(), null)));
                return 1;
            }
            if (item.method_7947() < amount) {
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)Utils.formatPlaceholders(Gts.language.getInsufficientItems(), minPrice, item.method_7954().getString(), player.method_5476().getString(), null)));
                return 1;
            }
            if (stackSize > amount || amount % stackSize != 0) {
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"The stack size can not be divided by amount."));
                return 1;
            }
            int numberOfStacks = amount / stackSize;
            for (int i = 0; i < numberOfStacks; ++i) {
                int totalExpiredListigs;
                int totalActiveListings = Gts.listings.getListingsByPlayer(player.method_5667()).size();
                if (totalActiveListings + (totalExpiredListigs = Gts.listings.getExpiredListingsOfPlayer(player.method_5667()).size()) >= Gts.config.getMaxListingsPerPlayer()) {
                    ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)Utils.formatPlaceholders(Gts.language.getMaximumListings(), 0.0, null, ((class_2168)context.getSource()).method_44023().method_5476().getString(), null)));
                    break;
                }
                class_1799 listingItem = item.method_7972();
                listingItem.method_7939(stackSize);
                ItemListing listing = new ItemListing(player.method_5667(), player.method_5477().getString(), price, listingItem);
                boolean success = GtsAPI.addListing(listing, player, null);
                if (success) {
                    ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)Utils.formatPlaceholders(Gts.language.getListingSuccess(), minPrice, listing.getListingName(), player.method_5476().getString(), null)));
                    continue;
                }
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)Utils.formatPlaceholders(Gts.language.getListingFail(), minPrice, listing.getListingName(), player.method_5476().getString(), null)));
            }
            return 1;
        }
        catch (NullPointerException e) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)Utils.formatPlaceholders(Gts.language.getItemIdNotFound(), 0.0, null, player.method_5476().getString(), null)));
            Gts.LOGGER.error("Couldn't find Item ID\n Stacktrace: ");
            e.printStackTrace();
            return 1;
        }
    }

    public int showPokemonUsage(CommandContext<class_2168> context) {
        String usage = "\u00a79Usage:\n\u00a73- gts sell pokemon <slot> <price>";
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)Utils.formatMessage(usage, ((class_2168)context.getSource()).method_43737())));
        return 1;
    }

    public int showItemUsage(CommandContext<class_2168> context) {
        String usage = "\u00a79Usage:\n\u00a73- gts sell item <price> <quantity> [stack size]";
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)Utils.formatMessage(usage, ((class_2168)context.getSource()).method_43737())));
        return 1;
    }
}

